<?php

namespace App\Services;

use App\supplier1\SupplierOneAdapter;
use App\supplier1\CategorySplitter;
use App\supplier1\DataChecker;
use App\supplier1\CategoryComparison;
use App\supplier1\EcoCategoryComparison;


class SupplierOneService {
    private $adapter;
    private $categorySplitter;
    private $dataChecker;
    private $categoryComparison;
    private $ecoCategoryComparison;

    public function __construct() {
        $this->adapter = new SupplierOneAdapter();
        $this->categorySplitter = new CategorySplitter();
        $this->dataChecker = new DataChecker();
        $this->categoryComparison = new CategoryComparison();
        $this->ecoCategoryComparison = new EcoCategoryComparison();
    }

    public function importData() {
        $products = $this->adapter->fetchProducts();

        // Perform data checking
        $hasInvalidCategories = $this->dataChecker->checkData($products);

        // If invalid categories are found, stop execution
        // if ($hasInvalidCategories) {
        //     echo "There are invalid categories. Please fix them and run the script again.\n";
        //     return; // Stop further execution
        // }

        // Split categories
        $this->categorySplitter->splitCategories($products);
        
        // Compare categories
        $this->categoryComparison->compareCategories();

        // Eco categories comparison
        $this->ecoCategoryComparison->compareEcoCategories();
    }

    public function processFormData($formData) {
        // Extract the selected main categories and their corresponding subcategories
        $selectedCategories = $formData['main_category'] ?? [];

        // Pass the selected categories to the CategoryComparison class to add them to the CSV
        $this->categoryComparison->assignCategories($selectedCategories);
    }
}
